//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;

namespace Bench
{
	/// <summary>
	/// Podsumowanie dla UnmanagedUdpTest.
	/// </summary>
	public class UnmanagedUdpTest : NetworkTest
	{
		public UnmanagedUdpTest(string server, int port, int numberOfPackets, int packetSize) :
			base(server, port, numberOfPackets, packetSize)
		{
			UnmanagedNetworking.SynchUdpTest(Server, Port, NumberOfPackets, PacketSize);
		}

		public override void Start()
		{
			// Wykonanie testu
			StartCounters();
			int startTime = Environment.TickCount;
				
			UnmanagedNetworking.Start();

			int endTime = Environment.TickCount;
			StopCounters();

			TransmitByteCount = UnmanagedNetworking.TransmitByteCount();
			ReceivedByteCount = UnmanagedNetworking.ReceivedByteCount();
			Elapsed = (float)UnmanagedNetworking.Elapsed();

			UnmanagedNetworking.Stop();
		}
	}
}
